//SeaPortProgram
//July 15, 2017
//Frances Chico


import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Scanner;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import java.util.HashMap;

public class SeaPortProgram extends JFrame {
	static final long serialVersionUID = 123L;

	
	//Define variables
	private World world;
	static JTextArea displayArea;
	private JButton readButton;
	private JButton searchButton;
	private JLabel searchTarget;
	private Scanner inputScanner;
	private JScrollPane scrollPane;
	private JPanel displayPanel;
	private JFileChooser fileChooser;
	private JButton sortButton;
	String[] sortingStrings = { "weight", "length", "width", "draft" };;

	//GUI
	
	public SeaPortProgram() {
		setTitle("Sea Ports");
		setSize(800, 600);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setVisible(true);
		displayArea = new JTextArea();

		scrollPane = new JScrollPane(displayArea);
		add(scrollPane, BorderLayout.CENTER);

		readButton = new JButton("Open");
		searchButton = new JButton("Search");
		searchTarget = new JLabel("Search Box");
		sortButton = new JButton("Sort");

		final JTextField searchBox = new JTextField(10);
		final JComboBox<String> searchingCriteria = new JComboBox<String>();
		searchingCriteria.addItem("Index");
		searchingCriteria.addItem("Skill");
		searchingCriteria.addItem("Name");
		final JComboBox<String> jcbsort = new JComboBox<String>(sortingStrings);
		displayPanel = new JPanel();
		displayPanel.add(readButton);
		displayPanel.add(searchTarget);
		displayPanel.add(searchBox);
		displayPanel.add(searchingCriteria);
		displayPanel.add(searchButton);
		displayPanel.add(jcbsort);
		displayPanel.add(sortButton);
		add(displayPanel, BorderLayout.PAGE_START);
		readFileData();
		validate();
		readButton.addActionListener(new ActionListener() {
		
			public void actionPerformed(ActionEvent e) {
				readFileData();
			}
		});

		sortButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				displayArea
						.append("\n\n--------------------------Sorted data ------------------------------------\n");
				String type = jcbsort.getSelectedItem().toString();
				String resultText = sortType(type);
				displayArea.append(resultText);
			}
		});
		searchButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				displayArea.append("\nResult  \n");
				String searchString = searchBox.getText();
				String typeOFSearch = (String) searchingCriteria
						.getSelectedItem();
				displayArea.append("\t"
						+ world.search(typeOFSearch, searchString));
			}
		});

	}

	public void readFileData() {
		fileChooser = new JFileChooser(".");
		int result = fileChooser.showOpenDialog(new JFrame());
		if (result == JFileChooser.APPROVE_OPTION) {
			try {
				inputScanner = new Scanner(new FileReader(
						fileChooser.getSelectedFile()));
			} catch (FileNotFoundException e) {
				JOptionPane.showMessageDialog(null, "File Not Found.");
			}
		}
		world = new World(inputScanner);

	
		if (world.isJob) {
			Thread t = new Thread();
			t.start();
		}
		displayArea.setText(world.toString());
	}


	private String sortType(String type) {
		String result = "";
		ArrayList<Ship> ships = new ArrayList<>();

		for (SeaPort ms : world.getPorts()) {
			for (Ship m : ms.getShips()) {
				ships.add(m);
			}
		}

		if (type.equals("weight")) {
			Collections.sort(ships, new ShipComparator("width"));
		} else if (type.equals("Width")) {
			Collections.sort(ships, new ShipComparator("4"));
		} else if (type.equals("length")) {
			Collections.sort(ships, new ShipComparator("length"));
		} else if (type.equals("draft")) {
			Collections.sort(ships, new ShipComparator("draft"));
		}

		for (Ship ship : ships) {
			result += ship.toString() + "\n";
		}
		return result;
	}

//Main 
	public static void main(String[] args) {
		new SeaPortProgram();
	}
}