//World
//July 15, 2017
//Frances Chico


import java.util.ArrayList;
import java.util.Scanner;



public class World extends Thing  {
	
	//Define variables
	private ArrayList<SeaPort> ports = new ArrayList<SeaPort>();
	private PortTime time;
	public long jobTime = 0;

	public Job currentJob = null;

	boolean printOn;
	ArrayList<Job> jobs;
	boolean isJob;
	
	   
    //Scanner constructor
	public World(Scanner scan) {
		super();
		isJob =false;
		jobs=new ArrayList<>();
		setTime(new PortTime(0));
		while (scan.hasNextLine()) {
			addEntry(scan.nextLine());
		}
	}

	
	public PortTime getTime() {
		return time;
	}


	public void setTime(PortTime time) {
		this.time = time;
	}

	
	public ArrayList<SeaPort> getPorts() {
		return ports;
	}


	public void setPorts(ArrayList<SeaPort> ports) {
		this.ports = ports;
	}

	
	//toString method
	public String toString() {
		String result = "\n\n------- The World -------";
		if (getPorts().size() == 0) {
			return result;
		}
		for (SeaPort seaPort : getPorts()) {
			result += seaPort;
		}
		return result;
	}

	
	@SuppressWarnings("resource")
	public void addEntry(String result) {
		Scanner scan = new Scanner(result);
		if (!scan.hasNext()) {
			return;
		}
		switch (scan.next()) {
		case "port":
			setPort(scan);
			break;
		case "pship":
			setPassengerShip(scan);
			break;
		case "dock":
			addDock(scan);
			break;
		
		case "cship":
			setCargoShip(scan);
			break;
		case "person":
			setPerson(scan);
			break;
		case "job":
			isJob =true;
			setJob(scan);
			
			break;
		default:
			break;
		}
		
		
		

	} 

	
	
	public void setPort(Scanner scan) {
		getPorts().add(new SeaPort(scan));
	}


	public void addDock(Scanner scan) {
		Dock tempDock = new Dock(scan);
		for (SeaPort seaPort : getPorts()) {
			if (seaPort.getIndex() == tempDock.getParent()) {
				seaPort.getDocks().add(tempDock);
			}
		}
	}


	public void setPassengerShip(Scanner scan) {
		PassengerShip tempPShip = new PassengerShip(scan);
		setShip(tempPShip);
	} 

	
	
	public void setCargoShip(Scanner scan) {
		CargoShip tempCShip = new CargoShip(scan);
		setShip(tempCShip);
	} 

	
	public void setPerson(Scanner scan) {
		Person tempPerson = new Person(scan);
		for (SeaPort seaPort : getPorts()) {
			if (seaPort.getIndex() == tempPerson.getParent()) {
				seaPort.getPerson().add(tempPerson);
			}
		}
	} 

	public void setJob(Scanner scan) {
		Job job = new Job(scan);
		addJob(job);
		
	} 
	public SeaPort getSeaPortByIndex(int x) {
		for (SeaPort seaPort : getPorts()) {
			if (seaPort.getIndex() == x) {
				return seaPort;
			}
		}
		return null;
	} 

	public Dock getDockByIndex(int x) {
		for (SeaPort seaPort : getPorts()) {
			for (Dock dock : seaPort.getDocks()) {
				if (dock.getIndex() == x) {
					return dock;
				}
			}
		}
		return null;
	} 

	

	

	
	
	public void setShip(Ship ship) {
		Dock dock = getDockByIndex(ship.getParent());
		if (dock == null) {
			getSeaPortByIndex(ship.getParent()).getShips().add(ship);
			getSeaPortByIndex(ship.getParent()).getQue().add(ship);
		} else {
			dock.setShip(ship);
			getSeaPortByIndex(dock.getParent()).getShips().add(ship);
		}
	} 

	
	
	public String search(String type, String target) {
		String result = "";
		switch (type) {
		case "Name":
			result += searchByName(target);
			break;
		case "Index":
			try {
				result += searchByIndex(Integer.parseInt(target));
			} catch (NumberFormatException e) {
				result += "Not a valid search target for Index";
			}
			break;
		case "Skill":
			result += searchByType(target);
			break;
		default:
			break;
		}
		return result;
	}


	public String searchByName(String target) {
		for (SeaPort seaPort : getPorts()) {
			if (seaPort.getName().equals(target)) {
				return seaPort.toString();
			}
			for (Dock dock : seaPort.getDocks()) {
				if (dock.getName().equals(target)) {
					return dock.toString();
				}
			}
			for (Ship ship : seaPort.getShips()) {
				if (ship.getName().equals(target)) {
					return ship.toString();
				}
			}
			for (Person person : seaPort.getPerson()) {
				if (person.getName().equals(target)) {
					return person.toString();
				}
			}
		}
		return "Result Not Found";
	}


	public String searchByIndex(int target) {
		for (SeaPort seaPort : getPorts()) {
			if (seaPort.getIndex() == target) {
				return seaPort.toString();
			}
			for (Dock dock : seaPort.getDocks()) {
				if (dock.getIndex() == target) {
					return dock.toString();
				}
			}
			for (Ship ship : seaPort.getShips()) {
				if (ship.getIndex() == target) {
					return ship.toString();
				}
			}
			for (Person person : seaPort.getPerson()) {
				if (person.getIndex() == target) {
					return person.toString();
				}
			}
		}
		return "Result Not Found";
	} 


	public String searchByType(String target) {
		String result = "";
		for (SeaPort seaPort : getPorts()) {
			for (Person person : seaPort.getPerson()) {
				if (person.getSkill().equals(target)) {
					result += person.toString() + '\n';
				}
			}
		}
		if (result == "") {
			return "Result Not Found";
		}
		return result;
	}
	
	
	public void addJob(Job job) {
		currentJob = job;
		jobTime = job.getPortTime().getTime();
		jobs.add(job);
		
		
	}

	
}
		
		
		
	


