import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Scanner;

public class Project4 {

	/**
	 * Read students from file into a list
	 * 
	 * @param filename
	 * @return the list of students
	 */
	static ArrayList<Student> readFromFile(String filename) {
		ArrayList<Student> students = new ArrayList<Student>();
		try (Scanner in = new Scanner(new File(filename))) {
			while (in.hasNextLine()) {
				String[] fields = in.nextLine().split(",");
				students.add(new Student(Integer.parseInt(fields[1]), fields[0], fields[2]));
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		return students;
	}

	/**
	 * Write the students to a file
	 * 
	 * @param students
	 * @param filename
	 */
	static void writeToFile(ArrayList<Student> students, String filename) {
		try (FileWriter out = new FileWriter(filename)) {
			for (Student s : students) {
				out.write(s.toString());
				out.write("\n");
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Sorts the students list by school. Same school students are sorted by ID.
	 * 
	 * Performs two stable sorts with different criteria. One sort and then another sort.
	 * 
	 * @param students
	 */
	static void sortBySchoolById1(ArrayList<Student> students) {
		// Your code here
		
	}

	/**
	 * Sorts the students list by school. Same school students are sorted by ID.
	 * 
	 * Performs only one sort that uses a comparator that takes both criteria
	 * into account.
	 * 
	 * @param students
	 */
	static void sortBySchoolById2(ArrayList<Student> students) {
		// Your code here
		
	}

	/**
	 *      Use this function in your bucket sort
	 *
	 * Return the bucket index for each school (schools in alphabetical order)
	 * 
	 * "UCB", "UCD", "UCI", "UCLA", "UCM", "UCSD", "UCSF"
	 *   0		1	   2	  3	      4      5        6
	 * 
	 * @param school
	 * @return the bucket index
	 */
	private static int schoolToIndex(String school) {
		switch (school) {
		case "UCB":
			return 0;
		case "UCD":
			return 1;
		case "UCI":
			return 2;
		case "UCLA":
			return 3;
		case "UCM":
			return 4;
		case "UCSD":
			return 5;
		case "UCSF":
			return 6;
		default:
			System.err.println("Unknown school " + school);
			return -1;
		}
	}

	/**
	 * Sorts the students list by school. Same school students are sorted by ID.
	 * 
	 * Places all the students of the same school into an individual bucket and
	 * sorts each bucket separately.
	 * 
	 * @param students
	 * 
	 */
	
	static void sortBySchoolById3(ArrayList<Student> students) {
		final int NUM_SCHOOLS = 7;
		// an array of lists. Each element is a reference to a list.
		ArrayList<Student>[] buckets = (ArrayList<Student>[]) new ArrayList[NUM_SCHOOLS];
		
		// Your code here
		
	}

	public static void main(String[] args) {
		ArrayList<Student> students1 = readFromFile("students.txt");
		// make 2 other copies so we don't have to read the file again
		ArrayList<Student> students2 = new ArrayList<Student>(students1);
		ArrayList<Student> students3 = new ArrayList<Student>(students1);

		// let's time the three sorts for fun. Not really that accurate.
		long start, end;
		
		start = System.currentTimeMillis();
		sortBySchoolById1(students1);
		end = System.currentTimeMillis();
		System.out.println("Two stable sorts took " + (end - start)
				+ " milliseconds.");

		start = System.currentTimeMillis();
		sortBySchoolById2(students2);
		end = System.currentTimeMillis();
		System.out.println("One stable sort with a two criteria comparator took "
						+ (end - start) + " milliseconds.");

		start = System.currentTimeMillis();
		sortBySchoolById3(students3);
		end = System.currentTimeMillis();
		System.out.println("Bucket sort took " + (end - start)
				+ " milliseconds.");

		if (!(students1.equals(students2) && students2.equals(students3))) {
			System.out.println("Fix me: One or more sorts are incorrect.");
		}
		
		writeToFile(students3, "studentsSorted.txt");
	}
}
