
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class EchoServer {

  public static void main(String[] args) throws IOException {

    ServerSocket serverSocket = new ServerSocket(7000);

    System.out.println("The ITEC 6120/8120 Echo Server is now ready!");

    while (true) {
      Socket socket = serverSocket.accept();
      System.out.println("Accepted an echo request");
      System.out.println("... local socket address " + socket.getLocalSocketAddress());
      System.out.println("... remote socket address " + socket.getRemoteSocketAddress());

      InputStream input = socket.getInputStream();
      OutputStream output = socket.getOutputStream();

      while (true) {
        int b = input.read();
        if (b == -1) break;
        output.write(b);
      }

      socket.close();
    }

  }
}
